	.msfirst
;__R09SASE__________________________________________________________________________________________
;
;	MINI ROM MONITOR FOR THE N8VEM 6809 HOST PROCESSOR (WITH I/O BOARD, STAND ALONE,SERIAL)
;
;	WRITTEN BY: DAN WERNER -- 06/26/2010
;	based on the ROM by Andrew Lynch
;
;__________________________________________________________________________________________________
;
;
BROM 	EQU	1		LET DEVICE DRIVERS KNOW CODE IS IN ROM
*BDSKY	EQU	1		USE DSKY TO DISPLAY SECTOR INF
;
; DATA CONSTANTS
;__________________________________________________________________________________________________
;REGISTER		IO PORT		; FUNCTION


DRIVE	EQU	0		DRIVE ID (ADDRESS)
NCYL	EQU	1		NUMBER OF CYLINDERS
NHEAD	EQU	2		NUMBER OF HEADS
NSEC	EQU	3		NUMBER OF SECTORS/TRACK
CYL	EQU	4		CURRENT CYLINDER
HEAD	EQU	5		CURRENT HEAD
SEC	EQU	6		CURRENT SECTOR


	ORG	$F800


;__________________________________________________________________________________________________
;
; 	INITIALIZE 6809
;__________________________________________________________________________________________________	
MAIN:
	LDS	#STACK			; RESET STACK POINTER
	CLRA			        ; set direct page register to 0
	TFR	A,DPR			;
	CLRA				; CLEAR ACCUMULATOR A
	JSR	SERIALINIT		; INIT SERIAL PORT
	LDX	#INITMESSAGE
	JSR	DISPLAY_STRING
						
;__CONTRL_________________________________________________________________________________________
;
; 	MONITOR MAIN LOOP
;__________________________________________________________________________________________________
CONTRL:
	JSR	DISPLAY_CRLF		; DISPLAY CRLF						
	LDAA	#'>'			; CARRIAGE RETURN
	JSR	WRSER1			; OUTPUT CHARACTER
	JSR	IOF_CONINW		;
	JSR	WRSER1			; OUTPUT CHAR TO CONSOLE
					;					
	CMPA	#'D'			; IS DUMP MEMORY?
	BEQ	DUMP			;					
	CMPA	#'L'			; IS LOAD?
	BEQ	MLOAD			; YES, JUMP
	CMPA	#'M'			; IS CHANGE?
	BEQ	CHANGE			; YES, JUMP
	CMPA	#'P'			; IS PRINT?
	BEQ	PRINT			; YES, JUMP
	CMPA	#'G'			; IS GO?
	BEQ	GO			; YES JUMP
	CMPA	#'B'			; IS BOOT?
	BEQ	BOOT			; YES JUMP
					;
					; COMMAND NOT FOUND ISSUE ERROR
	LDAA	#'?'			; PRINT '?'
	JSR	WRSER1			; OUTPUT CHARACTER
	JSR	DISPLAY_CRLF		; DISPLAY CRLF						
	BRA	CONTRL			; RECEIVE NEXT CHARACTER	

MLOAD:
	JMP	LOAD	
	
BOOT:
*******************************************************************************************
* BOOT CODE
*******************************************************************************************
	LDX	#BOOTMESSAGE
	JSR	DISPLAY_STRING
	JSR	DISPLAY_CRLF		; DISPLAY CRLF						
	LDAA	#':'			; CARRIAGE RETURN
	JSR	WRSER1			; OUTPUT CHARACTER
	JSR	IOF_CONINW		;
	JSR	WRSER1			; OUTPUT CHAR TO CONSOLE
					;					
	CMPA	#'F'			; floppy?
	LBEQ	BOOTF			;					
	CMPA	#'H'			; hdd?
	LBEQ	BOOTH			; 
	BRA	CONTRL
	
DUMP:
	JSR 	OUTS			;
	JSR	BADDR			;
	PSHS	X			;
	JSR	OUTS			;
	JSR	BADDR			;
	PULS	X			;
	JSR	DISPLAY_CRLF		;
DUMP_LOOP:	
	JSR	DUMP_LINE		;
	CMPX	XHI			;
	BMI	DUMP_LOOP		;
	BRA	CONTRL			; RECEIVE NEXT CHARACTER	


GO:
	JSR	BADDR			; GET ADDRESS
	JSR	OUTS			; PRINT SPACE
	LDX	XHI			; LOAD X WITH ADDRESS
	JMP	$0000,X			; JUMP TO ADDRESS

; CHANGE MEMORY(M AAAA DD NN)
CHANGE:
	JSR	BADDR			; BUILD ADDRESS
	JSR	OUTS			; PRINT SPACE
	JSR	OUT2HS			;
	JSR	BYTE			;
	DEX				;
	STAA,X				;
	CMPA,X				;
	BNE	LOAD19			; MEMORY DID NOT CHANGE
	JMP	CONTRL			;

; PRINT CONTENTS OF STACK
PRINT:
	STS	SP			;
	LDX	SP			;
	LDAB	#$09			;
PRINT2:					;
	JSR	OUT2HS			; OUT 2 HEX & SPACE
	DECB				;
	BNE	PRINT2			; DONE? IF NO DO MORE
	JMP	CONTRL			; DONE? IF YES RETURN TO MAIN LOOP
			

LOAD:

LOAD3:
	JSR	IOF_CONINW
	CMPA	#'S'
	BNE	LOAD3		; FIRST CHAR NOT (S)
	JSR	IOF_CONINW	; READ CHAR
	CMPA	#'9'
	BEQ	LOAD21
	CMPA	#'1'
	BNE	LOAD3		; SECOND CHAR NOT (1)
	CLR	CKSM		; ZERO CHECKSUM
	JSR	BYTE		; READ BYTE
	SUBA	#$02		
	STAA	BYTECT		; BYTE COUNT
; BUILD ADDRESS
	BSR	BADDR
; STORE DATA
LOAD11:
	JSR	BYTE
	DEC	BYTECT
	BEQ	LOAD15		; ZERO BYTE COUNT
	STAA,X			; STORE DATA
	INX
	BRA	LOAD11

LOAD15:
	INC	CKSM
	BEQ	LOAD3
LOAD19:
	LDAA	#'?'
	JSR	WRSER1
LOAD21:
C1	JMP	CONTRL
	

	
DUMP_LINE:
	JSR	OUTADDR			;
	JSR	OUTS			;
	PSHS	X			;
	LDAB	#$10			;		
DUMP_LINE_LOOP:	
	JSR	OUT2HS			; OUT 2 HEX & SPACE
	DECB				;
	BNE	DUMP_LINE_LOOP		; DONE? IF NO DO MORE
	PULS	X			;
	JSR	OUTS			;
	LDAA	#':'			;
	JSR	WRSER1			;
	LDAB	#$10			;			
DUMP_LINE_LOOPA:		
	LDAA	0,X			;
	CMPA	#32			;
	BMI	DUMP_LINE_INVALID	;
	CMPA	#127			;
	BPL	DUMP_LINE_INVALID	;
	JSR	WRSER1			;
	JMP	DUMP_LINE_VALID		;
DUMP_LINE_INVALID:			;	
	LDA	#'.'			;
	JSR	WRSER1			;
DUMP_LINE_VALID:			;
	INX				;	
	DECB				;
	BNE	DUMP_LINE_LOOPA		; DONE? IF NO DO MORE	
	JSR	DISPLAY_CRLF		;
	RTS	
	
; INPUT HEX CHAR
INHEX:
	JSR	IOF_CONINW		;
	PSHS	A			;
	JSR	WRSER1			;
	PULS	A			;
	CMPA	#$30			;
	BMI	C1			; NOT HEX
	CMPA	#$39			;
	BLE	IN1HG			;
	CMPA	#$41			;
	BMI	C1			; NOT HEX
	CMPA	#$46			;
	BGT	C1			; NOT HEX
	SUBA	#$07			;
IN1HG:					;
	RTS				;

; BUILD ADDRESS
BADDR:
	BSR	BYTE		; READ 2 FRAMES
	STAA	XHI
	BSR	BYTE
	STAA	XLOW
	LDX	XHI		; (X) ADDRESS WE BUILT
	RTS

; INPUT BYTE (TWO FRAMES)
BYTE:
	BSR	INHEX		; GET HEX CHAR
	ASLA
	ASLA
	ASLA
	ASLA
	TAB
	BSR	INHEX
	ANDA	#$0F		; MASK TO 4 BITS
	ABA
	TAB
	ADDB	CKSM
	STAB	CKSM
	RTS



OUTHL:
	LSRA			; OUT HEX LEFT BCD DIGIT
	LSRA			;
	LSRA			;
	LSRA			;

OUTHR:				;
	ANDA	#$0F		; OUT HEC RIGHT DIGIT
	ADDA	#$30		;
	CMPA	#$39		;
	BLS	OUTHR1		;
	ADDA	#$07		;
OUTHR1:	
	JMP	WRSER1		;

OUT2H:
	LDAA	0,X		; OUTPUT 2 HEX CHAR
	BSR	OUTHL		; OUT LEFT HEX CHAR
	LDAA	0,X		;
	BSR	OUTHR		; OUT RIGHT HEX CHAR
	INX
	RTS
	
OUTADDR:
	PSHS	X		;
	PULS	A		;
	PSHS	A		;
	BSR	OUTHL		; OUT LEFT HEX CHAR
	PULS	A		;
	BSR	OUTHR		; OUT RIGHT HEX CHAR
	PULS	A		;
	PSHS	A		;
	BSR	OUTHL		; OUT LEFT HEX CHAR
	PULS	A		;
	BSR	OUTHR		; OUT RIGHT HEX CHAR
	RTS	

OUT2HS:
	BSR	OUT2H		; OUTPUT 2 HEX CHAR + SPACE
OUTS:
	LDAA	#$20		; SPACE
	JMP	WRSER1		;

	
*___BOOT FROM FLOPPY, TRACK 80, H 0 & 1
BOOTF:
	JSR	SETUPDRIVE
	LDU	#$1000
	LDAA	#$01
	STAA	DRIVE,U
	LDAA	#$02
	STAA	NHEAD,U
	LDAA	#$09
	STAA	NSEC,U
	LDAA	#80
	STAA	NCYL,U
	LDAA	#78
	STAA	CYL,U
	CLRA
	STAA	HEAD,U
	STAA	SEC,U
	JSR	SETTRACK
	LDX	#$C700
	JMP 	DOBOOT

*___BOOT FROM HDD, TRACK 80, H 0 & 1
BOOTH:
	JSR	IDE_SOFT_RESET
	LDU	#$1000
	LDAA	#$00
	STAA	DRIVE,U
	LDAA	#$01
	STAA	NHEAD,U
	LDAA	#$FF
	STAA	NSEC,U
	LDAA	#$FF
	STAA	NCYL,U
	LDAA	#$FD
	STAA	CYL,U
	CLRA
	STAA	HEAD,U
	STAA	SEC,U
	LDX	#$C700
	JMP 	DOBOOT

	
		
	
DOBOOT:
	IFD	BDSKY
	JSR	SEGDISPLAY
	ENDIF
	LDAA	DRIVE,U
	BNE	BOOTFL
	JSR	IDE_READ_SECTOR
	JMP 	BOOTCONT	
BOOTFL:		
	PSHS	X
	JSR	READFL
	CMPA	#$03
	BHS	BOOTRETRY
	PULS	D
	ADDD	#$0200
	PSHS	D
	PULS	X
BOOTCONT:
	CPX	#$F000
	BHS	BOOTDONE
	LDAA	SEC,U
	INCA
	STAA	SEC,U
	CMPA	NSEC,U
	BNE	DOBOOT
	CLRA
	STAA	SEC,U
	LDAA	HEAD,U
	INCA
	STAA	HEAD,U
	CMPA	NHEAD,U
	BNE	DOBOOT
	CLRA
	STAA	SEC,U
	STAA	HEAD,U
	LDAA	CYL,U
	INCA
	STAA	CYL,U
	CMPA	NCYL,U
	BNE	DOBOOT

	
	
BOOTDONE:
	JMP	$C808
BOOTRETRY:	
	LDAA	CYL,U		;
	PSHS	A
	CLRA
	STAA	CYL,U
	JSR	SETTRACK
	PULS	A
	STAA	CYL,U
	JSR	SETTRACK
	PULS	X
	BRA	DOBOOT	
		
;__________________________________________________________________________________________________________	
	
DISPLAY_CRLF:	
	LDAA	#$0D			; PRINT CR
	JSR	WRSER1			; OUTPUT CHARACTER
	LDAA	#$0A			; PRINT LF
	JSR	WRSER1			; OUTPUT CHARACTER
	RTS	

DISPLAY_STRING:	
	LDAA	,X			; GET CHAR
	BEQ	DISPLAY_STRING_END
	JSR	WRSER1			; OUTPUT CHARACTER
	INX
	BRA	DISPLAY_STRING
DISPLAY_STRING_END:	
	RTS	
	
	
IOF_CONINW:				;
	JSR	RDSER1			;
	CMPA	#$FF			;
	BEQ	IOF_CONINW		;
	RTS
	
	
	include CUBIXOS\CUBIDE.asm	IDE I/O DRIVERS
	include CUBIXOS\CUBSER.asm	SERIAL I/O DRIVERS
	include CUBIXOS\CUBFLP.asm	FLOPPY I/O DRIVERS

	IFD	BDSKY
	include CUBIXOS\CUBDSKY.asm	DSKY I/O DRIVERS
	ENDIF
	
INITMESSAGE	FCB	$0D,$0A,$0D,$0A
		FCC	'N8VEM 6809 ROM MONITOR READY.'
		FCB	$0D,$0A,$00
		
BOOTMESSAGE	FCB	$0D,$0A
		FCC	'BOOT FROM (F)LOPPY OR (H)DD'
		FCB	$0D,$0A,$00
		

; DATA
RESTAB	FCB	3,0,2,0,0,3,4,1


STACK	EQU	$2100		; STACK POINTER

; REGISTERS FOR GO
SP	EQU	$0108		; S-HIGH
	
; END REGISTERS FOR GO
CKSM	EQU	$010A		; CHECKSUM
BYTECT	EQU	$010B		; BYTE COUNT
XHI	EQU	$010C		; XREG HIGH
XLOW	EQU	$010D		; XREG LOW

* CUBIX WITH NO VDU SPACE
*	org	$FFF2
*	FCW	$E75C
*	FCW	$E758
*	FCW	$E764
*	FCW	$E760
*	FCW	$E754
*	FCW	$E768
* CUBIX WITH VDU SPACE	
	org	$FFF2
	FCW	$DE5C
	FCW	$DE58
	FCW	$DE64
	FCW	$DE60
	FCW	$DE54
	FCW	$DE68

	ORG	$FFFE		; SET RESET VECTOR TO MAIN PROGRAM
RESETV	FCW	MAIN

	END
